/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rooms.constructions;

import com.badlogic.gdx.math.GridPoint2;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.furniture.FurnitureEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.QuantifiedItemType;
import technology.rocketjump.undermount.jobs.model.Job;
import technology.rocketjump.undermount.misc.VectorUtils;
import technology.rocketjump.undermount.rooms.ItemAllocation;
import technology.rocketjump.undermount.rooms.constructions.Construction;

public class FurnitureConstruction
extends Construction {
    private final Entity furnitureEntityToBePlaced;
    private final Set<GridPoint2> tileLocations;
    private final GridPoint2 primaryLocation;
    private Job constructionJob;
    private final List<QuantifiedItemType> requirements;
    private final List<ItemAllocation> allocatedItems = new LinkedList<ItemAllocation>();

    public FurnitureConstruction(Entity furnitureEntityToBePlaced) {
        this.furnitureEntityToBePlaced = furnitureEntityToBePlaced;
        this.tileLocations = new HashSet<GridPoint2>();
        GridPoint2 location = VectorUtils.toGridPoint(furnitureEntityToBePlaced.getLocationComponent().getWorldPosition());
        FurnitureEntityAttributes attributes = (FurnitureEntityAttributes)furnitureEntityToBePlaced.getPhysicalEntityComponent().getAttributes();
        for (GridPoint2 extraTileOffset : attributes.getCurrentLayout().getExtraTiles()) {
            this.tileLocations.add(location.cpy().add(extraTileOffset));
        }
        this.tileLocations.add(location);
        this.primaryLocation = location;
        List<QuantifiedItemType> requirements = attributes.getFurnitureType().getRequirements().get((Object)attributes.getPrimaryMaterialType());
        if (requirements == null) {
            System.err.println("Constructing " + attributes.getFurnitureType().getName() + " from  " + (Object)((Object)attributes.getPrimaryMaterialType()) + " which has no requirements");
            this.requirements = new ArrayList<QuantifiedItemType>();
        } else {
            this.requirements = requirements;
        }
    }

    @Override
    public long getId() {
        return this.furnitureEntityToBePlaced.getId();
    }

    @Override
    public Set<GridPoint2> getTileLocations() {
        return this.tileLocations;
    }

    @Override
    public Entity getEntity() {
        return this.furnitureEntityToBePlaced;
    }

    @Override
    public void allocationCancelled(ItemAllocation allocation) {
        this.allocatedItems.remove(allocation);
    }

    public Entity getFurnitureEntityToBePlaced() {
        return this.furnitureEntityToBePlaced;
    }

    public List<ItemAllocation> getAllocatedItems() {
        return this.allocatedItems;
    }

    public List<QuantifiedItemType> getRequirements() {
        return this.requirements;
    }

    public Job getConstructionJob() {
        return this.constructionJob;
    }

    public void setConstructionJob(Job constructionJob) {
        this.constructionJob = constructionJob;
    }

    public GridPoint2 getPrimaryLocation() {
        return this.primaryLocation;
    }
}

